<?php
// /libs/IntSmarty.php — compatibility shim for legacy phpLD code on Smarty 4
require_once __DIR__ . '/Smarty/Smarty.class.php';

class IntSmarty extends Smarty {
  public function __construct() {
    parent::__construct();

    // Point these to YOUR folders:
    $this->setTemplateDir(__DIR__ . '/../templates');        // change to /../views if needed
    $this->setCompileDir(__DIR__ . '/../temp/templates');    // compiled templates
    $this->setCacheDir(__DIR__ . '/../temp/cache');          // cache dir

    // Keep legacy/custom plugins if you have any:
    if (is_dir(__DIR__ . '/SmartyPlugins')) {
      $this->addPluginsDir(__DIR__ . '/SmartyPlugins');
    }

    // ✅ Always register a fallback for the {l}{/l} tag
    $this->registerPlugin('block', 'l', function ($params, $content, $tpl, &$repeat) {
      // If you have a translation system, you can process $content here.
      return $content ?? '';
    });
  }

  /* ---------------------------
   * Legacy snake_case aliases → Smarty 4 camelCase
   * These make old phpLD calls work without touching the codebase.
   * --------------------------- */

  // Data access
  public function assign_by_ref($tpl_var, &$value) { return $this->assignByRef($tpl_var, $value); }
  public function clear_assign($tpl_var)          { return $this->clearAssign($tpl_var); }
  public function get_template_vars($name = null) { return $this->getTemplateVars($name); }
  public function get_config_vars($name = null)   { return $this->getConfigVars($name); }
  public function config_load($file, $section = null) { return $this->configLoad($file, $section); }
  public function load_filter($type, $name)       { return $this->loadFilter($type, $name); }
  public function template_exists($name)          { return $this->templateExists($name); }

  // Plugins registration (Smarty 4 uses registerPlugin)
  public function register_function($name, $callback, $cacheable = true, $cache_attrs = null) {
    return $this->registerPlugin('function', $name, $callback);
  }
  public function unregister_function($name) {
    return $this->unregisterPlugin('function', $name);
  }
  public function register_modifier($name, $callback) {
    return $this->registerPlugin('modifier', $name, $callback);
  }
  public function unregister_modifier($name) {
    return $this->unregisterPlugin('modifier', $name);
  }
  public function register_block($name, $callback) {
    return $this->registerPlugin('block', $name, $callback);
  }
  public function unregister_block($name) {
    return $this->unregisterPlugin('block', $name);
  }

  // Registered objects
  public function register_object($name, $object, $allowed = array(), $smarty_args = true, $block_methods = array()) {
    return $this->registerObject($name, $object, $allowed, $smarty_args, $block_methods);
  }
  public function unregister_object($name) {
    return $this->unregisterObject($name);
  }
}
