<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
require_once 'init.php';

$error = 0;

$range = (preg_match ('`^[\d]+$`', $_REQUEST['range']) && $_REQUEST['range'] > 0 ? intval ($_REQUEST['range']) : 200);
$tpl->assign('range', $range);

if (empty ($_REQUEST['submit']) && !empty ($_SERVER['HTTP_REFERER']))
   $_SESSION['return'] = $_SERVER['HTTP_REFERER'];

//Build category tree
if (AJAX_CAT_SELECTION_METHOD == 0)
{
   $tpl->assign('categs', get_categs_tree());
}

//Load and run multiple article actions
require_once 'article_multi_action.php';

//Determine paging options
$PagerGroupings = (PAGER_GROUPINGS && PAGER_GROUPINGS > 0 ? intval (PAGER_GROUPINGS) : 20);
$ArticlesPerPage   = (LINKS_PER_PAGE  && LINKS_PER_PAGE  > 0 ? intval (LINKS_PER_PAGE)  : 10);

$tpl->assign('stats'  , array (0       => _L('Inactive'), 1     => _L('Pending'), 2             => _L('Active'),));

$columns = array ('TITLE' => _L('Title')   , 'DESCRIPTION' => _L('Description'), 'ARTICLE' => _L('Article'), 'CATEGORY' => _L('Category'), 'DATE_ADDED' => _L('Date Added'));
if (PAY_ENABLE == 1)
{
   $columns = array_merge ($columns, array ('ARTICLE_TYPE' => _L('Type')));
   $tpl->assign('link_type_str', $link_type_str);
}
$tpl->assign('columns', $columns);

//Determine column sorting URLs
$columnURLs = GetColSortUrls($columns, $current_item);
$tpl->assign('columnURLs', $columnURLs);

$tpl->assign('col_count', count ($columns) + 4);

$where = '';

//Determine article ID
$articleID = (isset ($_REQUEST['articleid']) ? $_REQUEST['articleid'] : '');

//Build where clause for article ID
if (!empty ($articleID))
{
   $articleID = urldecode ($articleID);

   //Clean multiple spaces, commas, etc
   $pattern  = array ( '/\s/', '`[,]+`', '`^[,]*`', '`[,]+$`' );
   $replace  = array ( ''    , ','     , ''       , ''        );
   $articleID = preg_replace ($pattern, $replace, $articleID);

   $articleIDArray = explode (',', $articleID);
   $articleIDArray = array_unique ($articleIDArray);

   //If editor, remove articles he/she is not allowed to view
   if (!$_SESSION['phpld']['adminpanel']['is_admin'])
   {
      //Loop through each category
      foreach ($articleIDArray as $key => $aid)
      {
         $cID = $db->GetOne("SELECT `CATEGORY_ID` FROM `{$tables['article']['name']}` WHERE `ID` = ".$db->qstr($aid));
         if (!in_array ($cID, $_SESSION['phpld']['adminpanel']['permission_array']))
         {
            //Current article category is not in editors permissions,
            //Remove from list
            unset ($articleIDArray[$key]);
         }
      }
   }

   if (!empty ($articleIDArray))
   {
      $where .= " AND {$tables['article']['name']}.ID IN ('".implode ("', '", $articleIDArray)."')";

      $_REQUEST['articleid'] = implode (',', $articleIDArray);

      $articleid = (!empty ($_REQUEST['articleid']) ? $_REQUEST['articleid'] : '');
      $tpl->assign('articleid', $articleid);
   }
}

//Determine category ID
//Keep backwards compatibility with urlvariable "c"
$category = (isset ($_REQUEST['category']) ? $_REQUEST['category'] : (isset ($_REQUEST['c']) ? $_REQUEST['c'] : ''));

//Build where clause for category ID
if (!empty ($category))
{
   $category = urldecode ($category);

   //Clean multiple spaces, commas, etc
   $pattern  = array ( '/\s/', '`[,]+`', '`^[,]*`', '`[,]+$`' );
   $replace  = array ( ''    , ','     , ''       , ''        );
   $category = preg_replace ($pattern, $replace, $category);

   $categsArray = explode (',', $category);
   $categsArray = array_unique ($categsArray);

   //If editor, remove articles he/she is not allowed to view
   if (!$_SESSION['phpld']['adminpanel']['is_admin'])
   {
      //Loop through each category
      foreach ($categsArray as $key => $cID)
      {
         if (!in_array ($cID, $_SESSION['phpld']['adminpanel']['permission_array']))
         {
            //Current category is not in editors permissions,
            //Remove from list
            unset ($categsArray[$key]);
         }
      }
   }

   if (!empty ($categsArray))
   {
      $where .= " AND {$tables['article']['name']}.CATEGORY_ID IN ('".implode ("', '", $categsArray)."')";

      $_REQUEST['category'] = implode (',', $categsArray);

      $category = (!empty ($_REQUEST['category']) ? $_REQUEST['category'] : '');
      $tpl->assign('category', $category);
   }
}

//Search by ID
$searchByID = (!empty ($_REQUEST['searchbyid']) && preg_match ('`^[\d]+$`', $_REQUEST['searchbyid']) ? intval ($_REQUEST['searchbyid']) : '');
$tpl->assign('searchbyid', $searchByID);
if (!empty ($searchByID))
{
   $where .= " AND {$tables['article']['name']}.ID LIKE ".$db->qstr('%'.$searchByID.'%');
   $_REQUEST['searchbyid'] = $searchByID;
}

//Initialize array for checkboxes
$checkboxes = array ();

//Determine article display order
$orderBy = "{$tables['article']['name']}.FEATURED DESC";
if (defined ('SORT_FIELD') && SORT_FIELD != '')
   $orderBy .= ", ". (SORT_FIELD == "CATEGORY" ? "{$tables['category']['name']}.TITLE" : "{$tables['article']['name']}.".SORT_FIELD)." ".SORT_ORDER;

$left_join_categ = " LEFT JOIN `{$tables['category']['name']}` ON ({$tables['article']['name']}.CATEGORY_ID = {$tables['category']['name']}.ID) ";

//Determine current index
$page         = ceil ($current_item / $ArticlesPerPage); // Determine page
$limit        = ' LIMIT '.($current_item <= 1 ? '0' : $current_item).', '.$ArticlesPerPage;

//Build search options
require_once '../search.php';
$search_preferences = array ();
$search_preferences['Select_Options']  = array ();
$search_preferences['Where_Options']   = array ();
$search_preferences['Order_Options']   = array ();
$search_preferences['Search_Location'] = array ( "{$tables['article']['name']}.URL" ,
                                                 "{$tables['article']['name']}.TITLE",
                                                 "{$tables['article']['name']}.DESCRIPTION"
                                                 );
//$search_preferences['BooleanSearchActive'] = 0;

//Get search queries
$ArticlesResults = search($search_preferences);
$search       = (!empty ($ArticlesResults['search']) ? $ArticlesResults['search'] : '');
$tpl->assign('search', $search);

//Get results
if ($_SESSION['phpld']['adminpanel']['is_admin'])
{
   //Count articles
   $list_total = $db->GetOne("SELECT COUNT(*) FROM `{$tables['article']['name']}` WHERE {$tables['article']['name']}.STATUS = '1' ".(!empty ($ArticlesResults['Search_Query']) ? " AND ".$ArticlesResults['Search_Query'] : '')." {$where}");
   $tpl->assign('list_total', $list_total);

   //Build SQL for results query
   $sql = "SELECT {$tables['article']['name']}.*, ".$db->IfNull("{$tables['category']['name']}.TITLE", "'Top'")." AS `CATEGORY` ".(!empty ($ArticlesResults['Select_Relevancy']) ? ", ".$ArticlesResults['Select_Relevancy'] : '')." FROM `{$tables['article']['name']}` LEFT JOIN `{$tables['category']['name']}` ON ({$tables['article']['name']}.CATEGORY_ID = {$tables['category']['name']}.ID) WHERE {$tables['article']['name']}.STATUS = '1' ".(!empty ($ArticlesResults['Search_Query']) ? " AND ".$ArticlesResults['Search_Query'] : '').(!empty ($ArticlesResults['Relevancy_Tuning']) ? $ArticlesResults['Relevancy_Tuning'] : '')." {$where} ORDER BY ".(!empty ($ArticlesResults['Relevancy_Order']) ? $ArticlesResults['Relevancy_Order'].", " : '')." {$orderBy}";

   //Get results
   $rs = $db->SelectLimit($sql, $ArticlesPerPage, ($current_item <= 1 ? '0' : $current_item - 1));

   if ($rs === false)
      $list = array ();
   else
      $list = $rs->GetAssoc(true);

   //Populate checkboxes array
   foreach ($list as $key => $value)
      $checkboxes[$key] = $value['TITLE'];
}
else
{
   //Count articles
   $list_total = $db->GetOne("SELECT COUNT(*) FROM `{$tables['article']['name']}` {$left_join_categ} WHERE {$tables['article']['name']}.STATUS = '1' ".(!empty ($ArticlesResults['Search_Query']) ? " AND ".$ArticlesResults['Search_Query'] : '')." {$where} AND (".preg_replace ('`(?:^|\s)ID(?:$|\s|=)`'," {$tables['article']['name']}.CATEGORY_ID ",$_SESSION['phpld']['adminpanel']['permission']).")");

   //Build SQL for results query
   $sql = "SELECT {$tables['article']['name']}.*, ".$db->IfNull("{$tables['category']['name']}.TITLE", "'Top'")." AS `CATEGORY` ".(!empty ($ArticlesResults['Select_Relevancy']) ? ", ".$ArticlesResults['Select_Relevancy'] : '')." FROM `{$tables['article']['name']}` {$left_join_categ} WHERE {$tables['article']['name']}.STATUS = '1' ".(!empty ($ArticlesResults['Search_Query']) ? " AND ".$ArticlesResults['Search_Query'] : '').(!empty ($ArticlesResults['Relevancy_Tuning']) ? $ArticlesResults['Relevancy_Tuning'] : '')." {$where} AND (".preg_replace ('`(?:^|\s)ID(?:$|\s|=)`'," {$tables['article']['name']}.CATEGORY_ID ",$_SESSION['phpld']['adminpanel']['permission']).") ORDER BY ".(!empty ($ArticlesResults['Relevancy_Order']) ? $ArticlesResults['Relevancy_Order'].", " : '')." {$orderBy}";

   //Get results
   $rs = $db->SelectLimit($sql, $ArticlesPerPage, ($current_item <= 1 ? '0' : $current_item - 1));

   if ($rs === false)
      $list = array ();
   else
      $list = $rs->GetAssoc(true);

   //Populate checkboxes array
   foreach ($list as $key => $value)
      $checkboxes[$key] = $value['TITLE'];
}

// Start Paging
SmartyPaginate :: connect(); // Connect Paging
SmartyPaginate :: setPageLimit($ArticlesPerPage); // Set default number of page groupings

// Build Paging
if ($page < 2)
{
   SmartyPaginate :: disconnect();
   SmartyPaginate :: reset     ();
}

$list_total     = (!empty ($list_total) && $list_total >= 0 ? intval ($list_total) : 0);

SmartyPaginate :: setPrevText    ('Previous'             );
SmartyPaginate :: setNextText    ('Next'                 );
SmartyPaginate :: setFirstText   ('First'                );
SmartyPaginate :: setLastText    ('Last'                 );
SmartyPaginate :: setTotal       ($list_total            );
SmartyPaginate :: setUrlVar      ('p'                    );
SmartyPaginate :: setUrl         ($_SERVER['REQUEST_URI']);
SmartyPaginate :: setCurrentItem ($current_item          );
SmartyPaginate :: setLimit       ($ArticlesPerPage          );
SmartyPaginate :: setPageLimit   ($PagerGroupings        );
SmartyPaginate :: assign         ($tpl                   );

unset ($list_total, $PagerGroupings, $ArticlesPerPage);

$min_keyword_length_comment = _L("Keywords shorter than #MIN_WORD_LENGTH# characters are ignored because of MySQL server settings.");
$min_keyword_length = (!empty ($ArticlesResults['Min_Word_Length']) ? $ArticlesResults['Min_Word_Length'] : '4');
$min_keyword_length_comment = str_replace ('#MIN_WORD_LENGTH#', $min_keyword_length, $min_keyword_length_comment);
$tpl->assign('min_keyword_length_comment', $min_keyword_length_comment);

$tpl->assign($_POST);
$tpl->assign('error', $error);
$tpl->assign('list', $list);
$tpl->assign('checkboxes', $checkboxes);

$content = $tpl->fetch(ADMIN_TEMPLATE.'/article_approve.tpl');
$tpl->assign('content', $content);

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Compress output for faster loading
if (COMPRESS_OUTPUT == 1)
   $tpl->load_filter('output', 'CompressOutput');

//Make output
echo $tpl->fetch(ADMIN_TEMPLATE.'/main.tpl');
?>