<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
require_once 'init.php';

// Disable any caching by the browser
disable_browser_cache();
if (isset ($_REQUEST['id']))
{
   $id     = $_REQUEST['id'];
   $action = 'pay';
}
elseif (isset ($_REQUEST['ID']))
{
   $id     = $_REQUEST['ID'];
   $action = 'pay';
}
elseif ($_REQUEST['payed'])
{
        $id     = $_REQUEST['payed'];
        $action = 'payed';
}
elseif ($_REQUEST['canceled'])
{
        $id     = $_REQUEST['canceled'];
        $action = 'canceled';
}

$id = (isset ($id) ? trim ($id) : 0);
$id = preg_replace ('`(id[_]?)`', '', $id);
$id = (preg_match ('`^[\d]+$`', $id) ? intval ($id) : 0);

if (!empty ($id))
{
   if (!empty ($_REQUEST['mode']) && $_REQUEST['mode'] == 'review')
   {
      $data = $db->GetRow("SELECT * FROM `{$tables['article_review']['name']}` WHERE `ARTICLE_ID` = ".$db->qstr($id));
      $data['ID'] = (!empty ($data['ARTICLE_ID']) ? $data['ARTICLE_ID'] : '');
      if (isset ($data['ARTICLE_ID']))
         unset ($data['ARTICLE_ID']);
   }
   else
      $data = $db->GetRow("SELECT * FROM `{$tables['article']['name']}` WHERE `ID` = ".$db->qstr($id));
}
//added 6-24-07
if($_SESSION['PRIVACY'] != '1')
         {
           $data['OWNER_EMAIL']= 'Hidden for Privacy Reasons.';
         }
// end add
if (empty ($data['ID']))
{
   echo $tpl->fetch('article_payment.tpl');
   exit();
}

$price = array ();

if ($data['ARTICLE_TYPE'] == '4')
{
if (ARTICLE_PAY_FEATURED > 0)
{
   $price[4] = ARTICLE_PAY_FEATURED;
}
 $ext = PAY_UMF;
  $sublength = PAY_UMF;
}

if ($data['ARTICLE_TYPE'] == '2')
{
if (ARTICLE_PAY_NORMAL > 0)
{
   $price[2] = ARTICLE_PAY_NORMAL;

 $ext = PAY_UMN;
 $sublength = PAY_UMN;
}
}

if ($data['ARTICLE_TYPE'] == '3')
{
if (PAY_RECPR > 0)
{
   $price[3] = PAY_RECPR;
}
 $ext = PAY_UMR;
 $sublength = PAY_UMR;
}


$SubscriptionEnabled = 0;

//RALUCA: JQuery validation related
$validators = array(
    'rules' => array(
            'quantity' => array(
                                    'digits' => true,
                                    'min' => '1'
                            )

    )
);

$vld = json_custom_encode($validators);
$tpl->assign('validators', $vld);

$validator = new Validator($validators);
//RALUCA: end of JQuery validation related

$tpl->assign('SubLength', $sublength);
if ($action=='pay')
{
        if (empty ($_REQUEST['submit']))
        {
                if (!empty ($_SERVER['HTTP_REFERER']))
                        $_SESSION['return'] = $_SERVER['HTTP_REFERER'];
        }
   else
   {
   //RALUCA: JQuery validation related - server side.
   $validator = new Validator($validators);
   $validator_res = $validator->validate($_POST);

   if (empty($validator_res))
   {
                        $pay_data = array ();
                        $pay_id   = $db->GenID($tables['payment']['name'].'_SEQ');
                        $pay_data['ID']        = $pay_id;
                        $pay_data['ARTICLE_ID']   = $data['ID'];
                        $pay_data['IPADDRESS'] = (!empty ($client_info['IP']) ? $client_info['IP'] : get_client_ip());
                        $pay_data['QUANTITY']  = $_REQUEST['quantity'];
                        $pay_data['AMOUNT']    = $price[$data['ARTICLE_TYPE']];
                        $pay_data['TOTAL']     = (int)$pay_data['QUANTITY'] * (float)$pay_data['AMOUNT'];
                        $pay_data['UM']        = $sublength;
                        $pay_data['PAY_DATE']  = gmdate ('Y-m-d H:i:s');
                        $pay_data['CONFIRMED'] = -1;
                        $pay_data['SUBSCRIBED'] = (isset ($_REQUEST['subscribe']) && $_REQUEST['subscribe'] == 1 && $SubscriptionEnabled == 1 ? 1 : 0);

                        if (db_replace('payment', $pay_data, 'ID') > 0)
                        {
                                $action = 'paypal';
                                $tpl->assign('PAYMENT', $pay_data);
                        }
         else
                                $tpl->assign('error', true);

                }
        }
        $quantity  = (!empty ($_REQUEST['quantity']) && preg_match ('`^[\d]+$`', $_REQUEST['quantity']) ? intval ($_REQUEST['quantity']) : 1);
   $subscribe = ($_REQUEST['subscribe'] == 1 ? 1 : 0);
}

$tpl->assign('quantity' , $quantity);
$tpl->assign('subscribe', $subscribe);
$tpl->assign('price'    , $price);
$tpl->assign('action'   , $action);

$path   = array ();
$path[] = array ('ID' => '0', 'TITLE' => _L(SITE_NAME)     , 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => SITE_DESC);
$path[] = array ('ID' => '0', 'TITLE' => _L('Article Payment'), 'TITLE_URL' => ''      , 'DESCRIPTION' => _L('Submit a new article to the directory '));
$tpl->assign('path', $path);

$tpl->assign('SubscribeOptions', array(0 => _L('No'), 1 => _L('Yes')) );

$tpl->assign($data);
$tpl->assign('payment_um', $payment_um);
$tpl->assign('SubscriptionEnabled', $SubscriptionEnabled);
$tpl->assign('SubscriptionPeriod', $Subscription['PERIOD']);
$tpl->assign('SubscriptionUm', $Subscription['UM']);
//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Make output
if ($action == 'paypal')
{
	echo $tpl->fetch('article_paypal.tpl');
    unset( $_SESSION['PRIVACY']);
}
else
   echo $tpl->fetch('article_payment.tpl');
?>
