<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */

require_once 'init.php';

//Determine link ID
if (ENABLE_REWRITE == 1)
{
   preg_match ('#(.*)author(_|-)(\d+)\.htm[l]?$#i', request_uri(), $matches);

   $id = (!empty ($matches[3]) ? intval ($matches[3]) : 0);
   if (empty($id)){
	    preg_match ('#(.*)owner(_|-)(\d+)\.htm[l]?$#i', request_uri(), $matches);

   $id = (!empty ($matches[3]) ? intval ($matches[3]) : 0);
   }
}
else
{
   $id = (!empty ($_REQUEST['id']) ? $_REQUEST['id'] : 0);
}

if (!empty ($id))
{
   if (!preg_match ('`^[\d]+$`', $id))
   {
      $tpl->assign('error', "Invalid Author ID");
   }
   else
   {
      $rdata = $db->GetRow("SELECT *, DATE_FORMAT(REGISTRATION_DATE, '%M %d, %Y %r') AS `DAT`,DATE_FORMAT(LAST_LOGIN, '%M %d, %Y %r') AS `DAT2` FROM `{$tables['user']['name']}` WHERE `ID` = ".$db->qstr($id));
      $data = array ();
      if (!$rdata)
         $tpl->assign('error', "Invalid ID [{$id}] passed - not found in database");
      else
      {
         $data['ID']           = $id;
         $data['NAME']         = $rdata['NAME'];
         $data['REG_DATE']     = $rdata['DAT'];
		 $data['LAST_LOGIN']     = $rdata['DAT2'];
         $data['INFO']         = $rdata['INFO'];
         //author avatar related
         $data['AUTH_IMG'] = $rdata['AUTH_IMG'];
         //end
         $data['WEBSITE']      = $rdata['WEBSITE'];
         $data['WEBSITE_NAME'] = $rdata['WEBSITE_NAME'];
		 $data['IMG_URL'] = $rdata['IMG_URL'];
         $data['META_KEYWORDS']    = $rdata['META_KEYWORDS'];
         $data['META_DESCRIPTION'] = $rdata['META_DESCRIPTION'];

         unset ($cdata, $site_url);
         $odata = $db->GetAll("SELECT * FROM `{$tables['link']['name']}` WHERE `OWNER_EMAIL` LIKE ".$db->qstr($rdata['EMAIL'])." AND `STATUS` = '2' LIMIT 0 , 30");

         usort ($odata, "cmp");
         $data['RELATED'] = "";
         foreach ($odata as $value)
            if ($value['ID'] !== $id)
            {
              
				 if (ENABLE_REWRITE == 1 ){
					 $surl =seo_url($value['ID'], $value['TITLE'], REWRITE_TYPE, REWRITE_EXT, 2); 
				 $link = SITE_URL.$surl;
				 }
               else
                  $link = SITE_URL."detail.php?id=" . $value['ID'];

               $data['RELATED'] .= "<li><a class=\"special\" href=\"{$link}\">{$value['TITLE']}</a></li>\n";
            }

         if($data['RELATED'])
            $data['RELATED'] = "<ul>\n{$data['RELATED']}</ul>\n";

         unset ($odata);

		  $odata1 = $db->GetAll("SELECT * FROM `{$tables['article']['name']}` WHERE `OWNER_EMAIL` LIKE ".$db->qstr($rdata['EMAIL'])." AND `STATUS` = '2' LIMIT 0 , 30");

         usort ($odata1, "cmp");
         $data['RELATED1'] = "";
         foreach ($odata1 as $value)
            if ($value['ID'] !== $id)
            {
              
				 if (ENABLE_REWRITE == 1 )
				{
				 $surl =seo_url($value['ID'], $value['TITLE'], REWRITE_TYPE, REWRITE_EXT, 1); 
				 $link = SITE_URL.$surl;
				}
               else
                  $link = SITE_URL."article.php?id=" . $value['ID'];

               $data['RELATED1'] .= "<li><a class=\"special\" href=\"{$link}\">{$value['TITLE']}</a></li>\n";
            }

         if($data['RELATED1'])
            $data['RELATED1'] = "<ul>\n{$data['RELATED1']}</ul>\n";

         unset ($odata1);
      }
   }
   unset ($rdata);
}
else
   $tpl->assign('error', "No ID parameter");

$path   = array ();
$path[] = array ('ID' => '0', 'TITLE' => _L(DIRECTORY_TITLE)		  , 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => SITE_DESC);
$path[] = array ('ID' => '0', 'TITLE' => _L('Profile Details'), 'TITLE_URL' => ''		, 'DESCRIPTION' => _L('Author Details'));

$tpl->assign('path', $path);
$tpl->assign($data);
$tpl->assign('SITE_NAME'      , SITE_NAME);
//$tpl->assign('ALLOW_AVATARS'  , ALLOW_AVATARS);

$tpl->assign('MetaKeywords'   , (!empty ($data['META_KEYWORDS'])    ? trim ($data['META_KEYWORDS'])    : trim ($MetaKeywords)));
$tpl->assign('MetaDescription', (!empty ($data['META_DESCRIPTION']) ? trim ($data['META_DESCRIPTION']) : trim ($MetaDescription)));

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Compress output for faster loading
if (COMPRESS_OUTPUT == 1)
   $tpl->load_filter('output', 'CompressOutput');

//Make output
echo $tpl->fetch('author.tpl', $id);

unset ($data);

?>