<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
require_once 'init.php';

//Disable any caching by the browser
disable_browser_cache();

if (!ENABLE_RSS)
   http_custom_redirect('index.php');

$expire_where = "AND (`EXPIRY_DATE` >= ".$db->DBDate(time())." OR `EXPIRY_DATE` IS NULL)";
//if required email confirmation add this to sql queries
if (EMAIL_CONFIRMATION == 1) {
    $email_conf = " AND `OWNER_EMAIL_CONFIRMED` = '1' ";
}
// Determine current index
$current_item = (!empty ($_REQUEST['p']) && preg_match ('`^[\d]+$`', $_REQUEST['p']) ? intval ($_REQUEST['p']) : 1);
$current_item--;

// Build limit query
$limit = ' LIMIT '.($current_item <= 1 ? '0' : $current_item).', '.PAGER_LPP;

// Define sorting options
define ('DIR_LPP', 20);
$sort_cols = array ('P' => 'PAGERANK', 'H' => 'HITS', 'A' => 'TITLE', 'D' => 'DATE_ADDED');
$sort_ord  = array ('P' => 'DESC'    , 'H' => 'DESC', 'A' => 'ASC'  , 'D' => 'DESC'      );

$getSort = (!empty ($_REQUEST['s']) ? trim ($_REQUEST['s']) : (!empty ($URLvariables['s']) ? $URLvariables['s'] : ''));

if (array_key_exists ($getSort, $sort_cols))
   $sort = $getSort;
else
   $sort = DEFAULT_SORT;

if (ENABLE_PAGERANK != 1 || SHOW_PAGERANK != 1 && $sort == 'P')
   $sort = 'H';

$feat_where = '';

if (isset ($_REQUEST['list']))
{
   switch ($_REQUEST['list'])
   {
      case 'latest':
         $sql   = "SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$email_conf} {$expire_where} ORDER BY `DATE_ADDED` DESC";
         $limit = LINKS_TOP;
         $tpl->assign('title', ' - Latest Links');
         break;
		case 'latestarticles':
         $sql   = "SELECT * FROM `{$tables['article']['name']}` WHERE `STATUS` = '2' ORDER BY `DATE_ADDED` DESC";
         $limit = LINKS_TOP;
         $tpl->assign('title', ' - Latest Articles');
		 $lart = '1';
         $tpl->assign('lart', $lart);
         break;
      case 'top':
         $sql   = "SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$email_conf} {$expire_where} ORDER BY `HITS` DESC";
         $limit = LINKS_TOP;
         $tpl->assign('title', ' - Top Hits');
         break;
      default:
         http_custom_redirect(DOC_ROOT.'/rss.php?c=0');
         break;
   }
}
elseif (isset ($_REQUEST['search']))
{
   require_once 'search.php';

   $search_preferences = array();
   $search_preferences['Select_Options']  = array ( '*' );
   $search_preferences['Where_Options']   = array ( "`STATUS` = '2'"            ,
                                                    "(`EXPIRY_DATE` >= ".$db->DBDate(time())." OR `EXPIRY_DATE` IS NULL)"
                                                    );
   $search_preferences['Order_Options']   = array ( '`'.$sort_cols[$sort].'` '.$sort_ord[$sort] );
   $search_preferences['Search_Location'] = array ( 'URL' ,
                                                    'TITLE',
                                                    'DESCRIPTION'
                                                    );
   $search_preferences['From_Table']      = $tables['link']['name'];
   //$search_preferences['BooleanSearchActive'] = 0;

   $LinksResults = search($search_preferences);

   if(empty ($LinksResults['errors']['empty_search'])) {
      $sql = $LinksResults['SQL_Query'].$limit;
   }

	$tpl->assign('title', ' - Search results');
	$tpl->assign('description', ' Search results for: '.htmlspecialchars($_REQUEST['search']));
}
elseif ($id = get_category())
{
	$sql = "SELECT * FROM `{$tables['link']['name']}` WHERE `STATUS` = '2' {$bydate} AND `CATEGORY_ID` = ".$db->qstr($id)." {$feat_where} {$email_conf} {$expire_where} ORDER BY `{$sort_cols[$sort]}` {$sort_ord[$sort]} {$limit}";

	$path = get_path($id);

	$url = '';
	$title = ' - ';
	for ($i = 1; $i < count ($path); $i++)
	{
		if (ENABLE_REWRITE)
			$url .= $path[$i]['TITLE_URL'].'/';
		if ($i > 1)
			$title .= ' &gt; ';

		$title .= $path[$i]['TITLE'];

	}
	if (!ENABLE_REWRITE)
		$url = 'index.php?c='.$id;

	$tpl->assign('title'      , xml_utf8_encode($title));
	$tpl->assign('description', xml_utf8_encode($path[count($path)-1]['DESCRIPTION']));
}

$tpl->assign('url', htmlspecialchars('http://'.$_SERVER['SERVER_NAME'].DOC_ROOT.'/'.$url));
$tpl->assign('surl', htmlspecialchars('http://'.$_SERVER['SERVER_NAME'].DOC_ROOT.'/'));

if ($limit > 0)
{
   $rs = $db->SelectLimit($sql, $limit);
   $links = $rs->GetRows();
}
else
   $links = $db->GetAll($sql);

$n = count ($links);
for ($i = 0; $i < $n; $i++)
{
	$links[$i]['ID']          = xml_utf8_encode($links[$i]['ID']);
	$links[$i]['TITLE']       = xml_utf8_encode($links[$i]['TITLE']);
	$links[$i]['DESCRIPTION'] = xml_utf8_encode($links[$i]['DESCRIPTION']);
	$links[$i]['URL']         = xml_utf8_encode($links[$i]['URL']);
	$links[$i]['RECPR_URL']   = xml_utf8_encode($links[$i]['RECPR_URL']);
	$links[$i]['OWNER_NAME']  = xml_utf8_encode($links[$i]['OWNER_NAME']);
	$links[$i]['OWNER_EMAIL'] = xml_utf8_encode($links[$i]['OWNER_EMAIL']);
}
if ($n > 0)
	$tpl->assign('links', $links);

// Article Rewrite
foreach($links as $k => $v)
   $links[$k]['SEO_URL1'] = seo_url($v['ID'], $v['TITLE'], REWRITE_TYPE, REWRITE_EXT, 1);
// Links Rewrite
foreach($links as $k => $v)
   $links[$k]['SEO_URL'] = seo_url($v['ID'], $v['TITLE'], REWRITE_TYPE, REWRITE_EXT, 2);
 $tpl->assign('links', $links);
 
@ header('Content-type: application/xml');

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Make output
echo $tpl->fetch('rss2.tpl');
?>