{capture name="title"} - {l}Search{/l}{/capture}
{capture assign="in_page_title"}{l}Search{/l}{/capture}
{capture assign="description"}{l}Search Directory{/l}{/capture}

{include file="header.tpl"}
{include file="top_bar.tpl"}

{include file="validation.tpl" form_id="submit_form" validators=$validators}

{strip}
{if $printSearchPage eq 'results'}
   {if isset($have_search_results) and $have_search_results == 0}

      {* NO RESULTS FOUND - PRINT ERROR MESSAGE *}

      <div>
         <p>{l}Sorry, no records found that match your keyword(s){/l}{if $search}: "{$search|escape|wordwrap:200:"\n":true}"{/if}</p>
         <p>{l}Suggestions{/l}:</p>
         <p>
            <ul>
               <li>{l}Make sure all words are spelled correctly{/l}.</li>
               <li>{l}Try different keywords{/l}.</li>
               <li>{l}Try more general keywords{/l}.</li>
            </ul>
         </p>
      </div>
   {else}

      {* RESULTS FOUND - PRINT THEM ALL *}
      {if !empty($searchquery)}<p>Search results for: <strong>{$searchquery|escape}</strong></p>{/if}


      {* Show category search results *}
      {if $search_category}
         {$search_category}
      {/if}

      {* Show article search results *}
      {if $search_article}
         {$search_article}
      {/if}

      {* Show link search results *}
      {if !empty($links)}
         <div class="titleBgmain"><h3>{l}Links{/l}</h3></div>
         <div id="links">
            {foreach from=$links item=link name=links}
               {include file="link.tpl" link=$link}
            {/foreach}
         </div>
      {/if}
   {/if}

   {* Javascript for tracking link clicks *}
   {if $StopLinkHits eq 0}
   <script type="text/javascript">
   /* <![CDATA[ */
      var root = '{$smarty.const.DOC_ROOT}';
      {literal}
      var a = document.getElementsByTagName("a");
      for(i = 0; i< a.length; i++)
         if(a[i].id != '')
            a[i].onclick = count_link;
      function count_link() {
         i = new Image();
         i.src= root+'/cl.php?id='+this.id;
         return true;
      }
      {/literal}
   /* ]]> */
   </script>
   {/if}

{elseif $printSearchPage eq 'form'}
<form method="post" action="{$smarty.const.DOC_ROOT}/search.php?type=advanced" id="submit_form">
<br />
<table border="0" class="formPage" align="center">
   {if $error}
   <tr><td colspan="2" class="err">
      {l}An error occured while saving search preferences{/l}.
      {if !empty($errorMsg)}
         <div>{$errorMsg|escape|trim}</div>
      {/if}
   </td></tr>
   {/if}

   <tr>
      <td class="label"><label for="search">Key Word(s):</label></td>
      <td class="field">
         <div>
            <input type="text" id="search" name="search" value="{$search|escape|trim}" size="40" class="text" />
         </div>
         <div>
            {html_options options=$titleonlyOptions selected=$titleonly name="titleonly"}
         </div>
      </td>
   </tr>

   <tr>
      <td class="label"><label for="location">Search in:</label></td>
      <td class="field">
         {html_checkboxes name="location" options=$locationOptions selected=$location separator="<br />"}
      </td>
   </tr>

   <tr>
      <td class="label"><label for="hitless">Find results with:</label></td>
      <td class="field">
         {html_options options=$hitlessOptions selected=$hitless name="hitless" id="hitless"}
         <input type="text" id="hitlimit" name="hitlimit" value="{$hitlimit}" size="5" class="text" /> {l}hits{/l}
      </td>
   </tr>

   <tr>
      <td class="label"><label for="sortby">Sort Results by:</label></td>
      <td class="field">
         {html_options options=$sortbyOptions selected=$sortby name="sortby" id="sortby"}
         {html_options options=$sortorderOptions selected=$sortorder name="sortorder" id="sortorder"}
      </td>
   </tr>

   <tr>
      <td class="label"><label for="categchoice">Search in categories:</label></td>
      <td class="field">
         {if $smarty.const.CAT_SELECTION_METHOD eq 2}
         	<div id="catTitle">
		 		{if !empty ($CategoryTitle)}{$CategoryTitle}{else}{l}Please select a category!{/l}{/if}
		 	</div>
		 	<span id="toggleCategTree">{l}Change category{/l}</span>
		 	<input type="hidden" id="CATEGORY_ID" name="categchoice[]" value="{$CATEGORY_ID}" />
		 	<div id="categtreebox"></div>
         {else}
         	<div>
            	{html_options options=$categchoiceOptions selected=$categchoice name="categchoice[]" id="categchoice" multiple="multiple"}
         	</div>
         {/if}
         <div>
            <label for="childcategs" title="{l}Will automatically search withing subcategories of selected categories{/l}"><input type="checkbox" id="childcategs" name="childcategs" value="1"{if $childcategs} checked="checked"{/if} title="{l}Select to search within subcategories{/l}" /> {l}Also search in subcategories{/l}</label>
         </div>
      </td>
   </tr>


   <tr>
      <td class="buttons">
         <input type="reset" id="reset" name="reset" value="{l}Reset Fields{/l}" title="{l}Reset all fields to default values{/l}" accesskey="r" class="btn"/>
      </td>
      <td class="buttons">
         <input type="submit" id="search" name="submit" value="{l}Search Now{/l}" title="{l}Start searching now{/l}" accesskey="s" class="btn" />
      </td>
   </tr>
</table>
<input type="hidden" name="formSubmitted" value="1" />
</form>
{/if}

{include file="footer.tpl"}
{/strip}