{capture name="title"} - {l}Link Payment{/l}{/capture}
{capture assign="in_page_title"}{l}Link Payment{/l}{/capture}
{capture assign="description"}{l}Submit a new link to the directory{/l}{/capture}

{include file="header.tpl"}
{include file="top_bar.tpl"}
{include file="top_bar.tpl"}
  {include file="validation.tpl" form_id="submit_payment_form" validators=$validators}
  
{strip}
	{if empty ($ID)}
		{l}Invalid link id.{/l}
	{else}
		<form method="post" action="" id="submit_payment_form">
		<table border="0" class="formPage">
		{if $action eq 'payed'}
			<tr>
			   <td colspan="2" class="msg">
			      {l}Thank you.{/l}
			      <br />
			      {l}Link submitted and awaiting approval or the payment to be processed.{/l}
			   </td>
			</tr>
		{elseif $action eq 'canceled'}
			<tr>
			   <td colspan="2" class="err">
			      {l}The payment was canceled.{/l}
			   </td>
			</tr>
		{/if}
		{if $error}
			<tr>
			   <td colspan="2" class="err">
			      {l}An error occured while saving the link payment data.{/l}
			   </td>
			</tr>
		{/if}
		<tr>
	  	  <td class="label">{l}Title{/l}:</td>
	  	  <td class="field">{$TITLE|escape|trim}</td>
		</tr>

		{if $URL|escape|trim != ''}
		<tr>
	  	  <td class="label">{l}URL{/l}:</td>
	  	  <td class="field">{$URL|escape|trim}</td>
  		</tr>
		{/if}
          {if $DESCRIPTION|escape|trim != ''}
        <tr>
  		  <td class="label">{l}Description{/l}:</td>
	  	  <td class="field">{$DESCRIPTION|escape|trim}</td>
		</tr>
		{/if}
 
		{if $OWNER_NAME|escape|trim != ''}
		<tr>
	  	  <td class="label">{l}Your Name{/l}:</td>
  		  <td class="field">{$OWNER_NAME|escape|trim}</td>
		</tr>
		{/if}
 
        {if $OWNER_EMAIL|escape:decentity|trim != ''}
		<tr>
	 	   <td class="label">{l}Your Email{/l}:</td>
	 	   <td class="field">{$OWNER_EMAIL|escape:decentity|trim}</td>
		</tr>
		{/if}
 
       {if ($SubscriptionEnabled eq 1) && ($action != 'payed')}
		{* TODO: display subscription also when ($action == 'payed') *}
       <tr>
         <td class="label">{l}Subscribe{/l}</td>
         <td class="field">
            {html_radios name="subscribe" options=$SubscribeOptions selected=$subscribe separator="<br />"}
         </td>
      </tr>
      {/if}

		<tr>
         <td class="label">{l}Unit price{/l}</td>
         {assign var="um" value="`$SubLength`"}
         <td class="field">{$smarty.const.HTML_CURRENCY_CODE}{$price}  {if $SubscriptionEnabled eq 1}every {$SubscriptionPeriod} {$SubscriptionUm}{/if}</td>
		</tr>

      {if $action eq 'pay'}
		<tr>
         <td class="label">{l}Quantity{/l}</td>
         <td class="field">
            {if $SubLength ne 5}
			      <input type="text" name="quantity" value="{$quantity}" size="10" maxlength="5" class="text" />
		      {else}
			      {l}n/a{/l}<input type="hidden" name="quantity" value="1" />
		      {/if}
         </td>
		</tr>

		<tr>
         <td class="buttons" colspan="2" align="center">
            <input type="hidden" name="formSubmitted" value="1" />
            <input type="image" name="paypal" src="https://www.paypal.com/en_US/i/btn/x-click-but01.gif" alt="Make payments with PayPal - it's fast, free and secure!" onClick="this.submit();">
		</td>
		</tr>
      {/if}
		</table>
		</form>
	{/if}
   {include file="footer.tpl"}
{/strip}