<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	 
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
class LatestArticleMain extends Widget {
	var $name;
	var $type;
	var $tpl;
	
	function LatestArticleMain($name='', $type='', $tpl='') {
		$this->name = $name;
		$this->type = $type;
		$this->tpl = get_widget_tpl($name);
		$this->tpl->assign('date_format', '%D %H:%M:%S');
	}
	
	function getContent() {
		global $db;
		global $tables;
		
		if (EMAIL_CONFIRMATION == 1) {
		    $email_conf = " AND `OWNER_EMAIL_CONFIRMED` = '1' ";
		}
	    
		$set = $this->getFrontSettings();
	    if ($set['CACHE_RESULTS'] == "Yes") {
			$data = $db->CacheGetRow("SELECT *, DATE_FORMAT(DATE_ADDED, '%b %d') AS `DAT` 
								FROM `{$tables['article']['name']}` 
								WHERE (`RELEASE_DATE`<= now()) 
								AND (`STATUS` = '2') 
								{$email_conf} 
								ORDER BY `DATE_ADDED` DESC LIMIT 0, 1");
		} else {
			$data = $db->GetRow("SELECT *, DATE_FORMAT(DATE_ADDED, '%b %d') AS `DAT` 
								FROM `{$tables['article']['name']}` 
								WHERE (`RELEASE_DATE`<= now()) 
								AND (`STATUS` = '2') 
								{$email_conf} 
								ORDER BY `DATE_ADDED` DESC LIMIT 0, 1");
		}
		
		$data['ARTICLE']        = stripslashes ($data['ARTICLE']);
		$cdata = $db->GetRow("SELECT `TITLE` AS `CATEGORY_TITLE`, `CACHE_TITLE`, `CACHE_URL` 
				FROM `{$tables['category']['name']}` WHERE `ID` = '{$data['CATEGORY_ID']}' LIMIT 1");
		$data['CATEGORY_TITLE'] = $cdata['CATEGORY_TITLE'];
		$data['CACHE_TITLE'] = $cdata['CACHE_TITLE'];
		$site_url = (substr (SITE_URL, -1) != '/' ? SITE_URL.'/' : SITE_URL);
		$data['CATEGORY_URL'] = $site_url;
		$data['CATEGORY_URL'] .= (ENABLE_REWRITE == 1 ? trim ($cdata['CACHE_URL']) : 'index.php?c='.$data['CATEGORY_ID']);
		$data['OWNER_ID']       = $rdata['OWNER_ID'];
		if (isset($_SESSION['phpld']['user']['id'])) {
			$data['rights'] =  user_needs_approval($_SESSION['phpld']['user']['id'], $data['CATEGORY_ID']);
			$data['has_payment'] = article_has_payment($data['ID']);
		}
		if ($data['OWNER_ID']) {
			$odata = $db->GetRow("SELECT * FROM `{$tables['user']['name']}` WHERE `ACTIVE` = '1' AND `ID` = ".$data['OWNER_ID']);
			$data['ANONYMOUS']    = $odata['ANONYMOUS'];
			if ($odata['ANONYMOUS'] == 0 || ALLOW_ANONYMOUS == 0) {
				if (ALLOW_AUTHOR_INFO == 1) {
					$data['NAME']     = "<a href=\"".DOC_ROOT."/";
					if (ENABLE_REWRITE) {
						$data['NAME']  .= "authors/author-".$data['OWNER_ID'].".html";
					} else {
						$data['NAME']  .= "author.php?id=".$data['OWNER_ID'];
					}
					$data['NAME']  .= "\" title=\"".htmlspecialchars($odata['NAME'])."\">".htmlspecialchars($odata['NAME'])."</a>";
				} else {
					$data['NAME']     = $odata['NAME'];
				}
				$data['WEBSITE']    = $odata['WEBSITE'];
				$data['INFO']       = $odata['INFO'];
			} else {
				$data['NAME']       = "Anonymous";
				$data['ANONYMOUS']  = 1;
			}
		} else {
			$data['NAME']       = $data['OWNER_NAME'];
			$data['ANONYMOUS']  = 1;
		}
		$RATING                 = $data['RATING'] / $data['VOTES'];
		$data['RATING']         = substr($RATING, 0, 3);
		$data['SEO_URL'] = seo_url($data['ID'], $data['TITLE'], REWRITE_TYPE, REWRITE_EXT, 1);
		unset ($cdata, $site_url);
		$this->tpl->assign('ratings_on', ARTICLE_RATING);
		
		$this->tpl->assign($data);
		
		if ($set['DISPLAY_IN_BOX'] == "No") {
			$this->tpl->assign('show_title', 1);
		}
		$this->tpl->assign("SET_TITLE", $set['TITLE']);
		
		return $this->tpl->fetch('content.tpl');
	}
}

?>