<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
class LatestArticles extends Widget {
	var $name;
	var $type;
	var $tpl;
	
	function LatestArticles($name='', $type='', $tpl='') {
		$this->name = $name;
		$this->type = $type;
		$this->tpl = get_widget_tpl($name);
		$this->tpl->assign('date_format', '%D %H:%M:%S');
	}
	
	function getContent() {
		global $db;
		global $tables;

		//article permission related
		if (isset($_SESSION['phpld']['user']['id'])) {
	        if (get_user_level($_SESSION['phpld']['user']['id']) == 1 || get_user_level($_SESSION['phpld']['user']['id']) == 3 ) {
	              $permission_cats = "1 ";
	              $permission_links_arts = "1 ";
	        } else {
	           $permissions = get_user_permissions($_SESSION['phpld']['user']['id']);
	           $permission_cats = "`ID` IN (";
	           $permission_links_arts = "`CATEGORY_ID` IN (";
	           if (count($permissions) >0) {
	               for ($i=0; $i<count($permissions); $i++) {
	                   if ($i<count($permissions)-1) {
	                        $permission_cats .= "'".$permissions[$i]['CATEGORY_ID']."', ";
	                        $permission_links_arts .= "'".$permissions[$i]['CATEGORY_ID']."', ";
	                   } else {
	                        $permission_cats .= "'".$permissions[$i]['CATEGORY_ID']."') ";
	                        $permission_links_arts .= "'".$permissions[$i]['CATEGORY_ID']."') ";
	                   }
	               }
	           } else {
	               $permission_cats = "0 ";
	               $permission_cats_parents = "0 ";
	               $permission_links_arts = "0 ";
	           }
	       }
	    } else {
	        $permission_cats = "0 ";
	        $permission_cats_parents = "0 ";
	        $permission_links_arts = "0 ";
	    }
	
		//end of article permission realted
	    
		if (EMAIL_CONFIRMATION == 1) {
		    $email_conf = " AND `OWNER_EMAIL_CONFIRMED` = '1' ";
		}
	    
		$set = $this->getFrontSettings();
	    
		if (intval($set['NO_OF_ARTICLES']) > 0) {
			$limit = intval($set['NO_OF_ARTICLES']);
		} else {
			$limit = 10;
		}
		
		if ($set['CACHE_RESULTS'] == "Yes") {
			$latest_art = $db->CacheGetAll("SELECT *, DATE_FORMAT(DATE_ADDED, '%b %d') AS `DAT` 
								FROM `{$tables['article']['name']}` 
								WHERE (`RELEASE_DATE`<= now() OR {$permission_links_arts}) 
								AND (`STATUS` = '2' OR {$permission_links_arts}) 
								{$email_conf} 
								ORDER BY `DATE_ADDED` DESC LIMIT 0, ".$limit);
		} else {
			$latest_art = $db->GetAll("SELECT *, DATE_FORMAT(DATE_ADDED, '%b %d') AS `DAT` 
								FROM `{$tables['article']['name']}` 
								WHERE (`RELEASE_DATE`<= now() OR {$permission_links_arts}) 
								AND (`STATUS` = '2' OR {$permission_links_arts}) 
								{$email_conf} 
								ORDER BY `DATE_ADDED` DESC LIMIT 0, ".$limit);
		}
	    if (!empty($latest_art) && isset($_SESSION['phpld']['user']['id'])) {
	    	for ($i=0; $i<count($latest_art); $i++) {
	           $latest_art[$i]['rights'] =  user_needs_approval($_SESSION['phpld']['user']['id'], $latest_art[$i]['CATEGORY_ID']);
	           $latest_art[$i]['has_payment'] = article_has_payment($latest_art[$i]['ID']);
	        }
	    }
		foreach($latest_art as $k => $v) {
        	$latest_art[$k]['SEO_URL'] = seo_url($v['ID'], $v['TITLE'], REWRITE_TYPE, REWRITE_EXT, 1);
    	}
    	$this->tpl->assign('latest_art', $latest_art);
    	
    	if ($set['DISPLAY_IN_BOX'] == "No") {
			$this->tpl->assign('show_title', 1);
		}
		$this->tpl->assign("TITLE", $set['TITLE']);
    	
		return $this->tpl->fetch('content.tpl');
	}
}

?>