<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 class Widget  {

	var $name;
	var $type;

	function Widget($name='', $type='') {
		$this->name = $name;
		$this->type = $type;
	}
	
	function install() {
		global $db;
		global $tables;
		
		$wids = $db->GetAll("SELECT * FROM `{$tables['widget']['name']}` WHERE `NAME` = ".$db->qstr($this->name));
		if (count($wids) > 0) {
			return false;
		} else {
			$data = $this->getConfig();
	
			if ($db->Execute("INSERT INTO `{$tables['widget']['name']}` (`NAME`, `TYPE`, `DESCRIPTION`) VALUES (".$db->qstr($data['NAME']).",".$db->qstr($data['ZONETYPE']).", ".$db->qstr($data['DESCRIPTION']).")")) {
				for ($i=0; $i<count($data['SETTINGS']); $i++) {
					$db->Execute ("DELETE FROM `{$tables['widget_settings']['name']}` WHERE `WIDGET_NAME` = ".$db->qstr($this->name)." AND `SETTING_NAME` = ".$db->qstr($data['SETTINGS'][$i]['NAME'])."");
					
					$db->Execute("INSERT INTO `{$tables['widget_settings']['name']}` (`IDENTIFIER`, `WIDGET_NAME`, `SETTING_NAME`, `SETTING_VALUE`, `SETTING_INFO`, `SETTING_ALLOWED`)
								 VALUES(".$db->qstr($data['SETTINGS'][$i]['IDENTIFIER']).", ".$db->qstr($data['NAME']).", ".$db->qstr($data['SETTINGS'][$i]['NAME']).", ".$db->qstr($data['SETTINGS'][$i]['VALUE']).", ".$db->qstr($data['SETTINGS'][$i]['INFO']).", ".$db->qstr($data['SETTINGS'][$i]['ALLOWED']).")");
					
				}
				$db->Execute ("DELETE FROM `{$tables['widget_settings']['name']}` WHERE `WIDGET_NAME` = ".$db->qstr($this->name)." AND `SETTING_NAME` = 'DISPLAY IN BOX'");
				$db->Execute("INSERT INTO `{$tables['widget_settings']['name']}` (`IDENTIFIER`, `WIDGET_NAME`, `SETTING_NAME`, `SETTING_VALUE`, `SETTING_INFO`, `SETTING_ALLOWED`)
								 VALUES('DISPLAY_IN_BOX', ".$db->qstr($data['NAME']).", 'DISPLAY IN BOX', 'Yes', 'If \"Yes\", a box encloses the output of the widget on the frontend.', 'Yes,No')");
				return true;			
			} else {
				return false;
			}
		}
	}
	
	function uninstall() {
		global $db;
		global $tables;
		
		if ($db->Execute ("DELETE FROM `{$tables['widget']['name']}` WHERE `NAME` = ".$db->qstr($this->name)."")) {
			$db->Execute ("DELETE FROM `{$tables['widget_settings']['name']}` WHERE `WIDGET_NAME` = ".$db->qstr($this->name)."");
			$db->Execute ("DELETE FROM `{$tables['widget_activated']['name']}` WHERE `NAME` = ".$db->qstr($this->name)."");
			return true;
			
		} else {
			return false;
		}
	}
	
	function getConfig() {
		if (is_dir(INSTALL_PATH."/widgets/")) {
		    if ($dh = opendir(INSTALL_PATH."/widgets/")) {
		    	if (file_exists(INSTALL_PATH."/widgets/".$this->name."/config.xml")) {
		            	$wid = get_widget_xml($this->name);
		            	$wid['NAME'] = $this->name;
		        }
		        closedir($dh);
		    } else {
		    	return false;		
		    }
		} else {
			return false;
		}
		//if (!get_magic_quotes_gpc()) {
			//$wid = custom_stripslashes($wid);
		//}
		return $wid;
	}
	
	function getSettingsForm() {
		global $tpl;
		
		$settings = $this->getSettings();
		
		for($i=0; $i<count($settings); $i++) {
			$settings[$i]['SETTING_ALLOWED'] = explode(",", $settings[$i]['SETTING_ALLOWED']);
		}
		$tpl->assign('list', $settings);
		
		return $tpl->fetch('DefaultAdmin/dir_widgets_edit.tpl');
	}
	
	function getSettings() {
		global $db;
		global $tables;
		
		$set = array();
		
		$set = $db->GetAll("SELECT * FROM `{$tables['widget_settings']['name']}` WHERE `WIDGET_NAME` = ".$db->qstr($this->name));
		return $set;
	}
	
	function getFrontSettings() {
		global $db;
		global $tables;
		
		$set = array();
		
		$s = $db->GetAll("SELECT * FROM `{$tables['widget_settings']['name']}` WHERE `WIDGET_NAME` = ".$db->qstr($this->name));
		for ($i=0; $i<count($s); $i++) {
			$set[$s[$i]['IDENTIFIER']] = $s[$i]['SETTING_VALUE'];
		}
		
		return $set;
	}
	
	function saveSettings($set) {
		global $db;
		global $tables;
		if (count($set)>0 && $set[0]['WIDGET_NAME'] != $this->name) {
			return false;
		}

		for($i=0; $i<count($set); $i++) {
			$db->Execute("UPDATE `{$tables['widget_settings']['name']}` SET `SETTING_VALUE` = ".$db->qstr($set[$i]['SETTING_VALUE'])." WHERE `IDENTIFIER`=".$db->qstr($set[$i]['IDENTIFIER'])." AND `WIDGET_NAME` = ".$db->qstr($this->name)."");
		}
		return true;
	}
	
	function activate($zone) {
		global $db;
		global $tables;
		
		$max = $db->GetRow("SELECT MAX(`ORDER_ID`) AS m FROM `{$tables['widget_activated']['name']}` WHERE `ZONE` = ".$db->qstr($zone)."");
		
		$m = intval($max['m'])+1;
		
		if ($db->Execute("INSERT INTO `{$tables['widget_activated']['name']}` (`NAME`, `ZONE`, `ORDER_ID`) VALUES (".$db->qstr($this->name).", ".$db->qstr($zone).", ".$db->qstr($m).")")) {
			return true;
		} else {
			return false;
		}
	}
	
	function deactivate($zone) {
		global $db;
		global $tables;
		
		$wid = $db->GetRow("SELECT * FROM `{$tables['widget_activated']['name']}` WHERE `NAME` = ".$db->qstr($this->name)." AND `ZONE` = ".$db->qstr($zone)."");
		$db->Execute("UPDATE `{$tables['widget_activated']['name']}` SET `ORDER_ID`=`ORDER_ID`-1 
						WHERE `ORDER_ID` IS NOT NULL AND `ORDER_ID` > ".$db->qstr($wid['ORDER_ID'])." AND `ZONE` = ".$db->qstr($zone)."");
		
		if ($db->Execute("DELETE FROM `{$tables['widget_activated']['name']}` WHERE `NAME` = ".$db->qstr($this->name)." AND `ZONE` = ".$db->qstr($zone)."")) {
			return true;
		} else {
			return false;
		}
	}
	
		
	function move_up($zone) {
		global $db;
		global $tables;
		$w1 = $db->GetRow("SELECT * FROM `{$tables['widget_activated']['name']}` 
							WHERE `NAME` = ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."");
		if ($w1['ORDER_ID']>0) {
			$w2 = $db->GetRow("SELECT * FROM `{$tables['widget_activated']['name']}` 
								WHERE `ZONE` = ".$db->qstr($zone)." 
								AND `ORDER_ID` < ".$w1['ORDER_ID']." ORDER BY `ORDER_ID` DESC");
			
	
			if ($w2['ORDER_ID'] == '') {
				//all above widgets have order 1000
				//make order 0 for this one
				$db->Execute("UPDATE `{$tables['widget_activated']['name']}` 
							SET `ORDER_ID` = '0' 
							WHERE `NAME` = ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."");
				return true;					
			} else {
				$db->Execute("UPDATE `{$tables['widget_activated']['name']}` 
							SET `ORDER_ID` = ".$db->qstr($w2['ORDER_ID'])." 
							WHERE `NAME` = ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."");

				$db->Execute("UPDATE `{$tables['widget_activated']['name']}` 
							SET `ORDER_ID` = `ORDER_ID` + 1 
							WHERE `NAME` != ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."
							AND `ORDER_ID` = ".$db->qstr($w2['ORDER_ID']));
									
				return true;							
			}
		}
	}
	
	function move_down($zone) {
		global $db;
		global $tables;
		$w1 = $db->GetRow("SELECT * FROM `{$tables['widget_activated']['name']}` 
							WHERE `NAME` = ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."");
		if ($w1['ORDER_ID']!='') {
			$w2 = $db->GetRow("SELECT * FROM `{$tables['widget_activated']['name']}` 
								WHERE `ZONE` = ".$db->qstr($zone)." 
								AND `ORDER_ID` > ".$db->qstr($w1['ORDER_ID'])." ORDER BY `ORDER_ID` ASC");
			
			$db->Execute("UPDATE `{$tables['widget_activated']['name']}` 
							SET `ORDER_ID` = ".$db->qstr($w2['ORDER_ID'])." 
							WHERE `NAME` = ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."");

			$db->Execute("UPDATE `{$tables['widget_activated']['name']}` 
							SET `ORDER_ID` = `ORDER_ID` - 1 
							WHERE `NAME` != ".$db->qstr($this->name)." 
							AND `ZONE` = ".$db->qstr($zone)."
							AND `ORDER_ID` = ".$db->qstr($w2['ORDER_ID'])." AND `ORDER_ID`<1000");
			return true;							
		}
	}
}




?>