<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
require_once 'init.php';

$error = 0;
$errorMsg = '';

//Disable any caching by the browser
disable_browser_cache();

//Generate unique imagehash for visual confirmation
if (VISUAL_CONFIRM == 1)
{
   require_once 'include/functions_imgverif.php';
   $imagehash = fetch_captcha_hash();
   $tpl->assign('imagehash', $imagehash);
   //unset($imagehash);
}

//RALUCA: JQuery validation related
$validators = array(
	'rules' => array(
		'NAME' => array(
						'required' => true
				),
		'EMAIL' => array(
			'required' => true,
			'email' => true,
			'remote' => array(
					'url' => DIRECTORY_ROOT . "/include/validation_functions.php",
					'type'=> "post",
			        'data'=> array (
			        	'action' => "isBannedEmail",
			        	'table' => "user",
			        	'field' => "OWNER_EMAIL"
			        ))
		),	
		'SUBJECT' => array(
						'required' => true
		),
		'MESSAGE' => array(
						'required' => true
		)
	),
	'messages' => array(
		'EMAIL'=> array(
			'remote'  	=>_L("This email is banned.")
		),
		'CAPTCHA'=> array(
			'remote'  	=> _L("Incorrect code.")
		)
	)
);
if (VISUAL_CONFIRM == 1) {
	$validators['rules']['CAPTCHA'] = array(
		'required' => true,
	    'remote' => array(
					'url' => DIRECTORY_ROOT . "/include/validation_functions.php",
					'type'=> "post",
			        'data'=> array (
			        	'action'    => "isCaptchaValid",
			        	'table'     => "img_verification",
			        	'field'     => "CAPTCHA",
						'IMAGEHASH' => $imagehash
			        )
		  )
	);	
}
if (VISUAL_CONFIRM == 2) {
    $validators['rules']['DO_MATH'] = array(
   'required' => true
    );
   
}

$vld = json_custom_encode($validators);
$tpl->assign('validators', $vld);
$validator = new Validator($validators);
//RALUCA: end of JQuery validation related


$path   = array ();
$path[] = array ('ID' => '0', 'TITLE' => _L(SITE_NAME)    , 'TITLE_URL' => DOC_ROOT, 'DESCRIPTION' => SITE_DESC);
$path[] = array ('ID' => '0', 'TITLE' => _L('Contact Us') , 'TITLE_URL' => ''      , 'DESCRIPTION' => _L('Contact Us'));
$tpl->assign('path', $path);

//If current user is banned, show a custom error message
//and stop the rest of the script
check_if_banned();
if (BOT_CHECK == 1)
check_botscout($client_info['IP'],$_REQUEST['EMAIL'],BOT_KEY);
//Make an additional check if client is allowed to post/submit
//[Spam] protection
require_once 'include/check_post_rules.php';
$post_rules_unauthorized = check_post_rules($_POST);
if (empty ($_POST['submit']))
{
   if (!empty ($_SERVER['HTTP_REFERER']))
      $_SESSION['return'] = $_SERVER['HTTP_REFERER'];

   // Clear some varialbles
   if (isset($_SESSION['SmartyPaginate']))
      unset ($_SESSION['SmartyPaginate']);
   if (isset($_SESSION['values']))
      unset ($_SESSION['values']);
   if (VISUAL_CONFIRM == 2) {
	// do the math
	$n1 = rand(1,9);
	$n2 = rand(1,9);
	$hash = do_math($n1, $n2);

	$_SESSION['DO_MATH_N1'] = $n1;
	$_SESSION['DO_MATH_N2'] = $n2;

	// end do the math
	}
}
else
{

   $data = array ();
   $data['NAME']    = (!empty ($_REQUEST['NAME'])    ? strip_white_space ($_REQUEST['NAME'])    : '');
   $data['EMAIL']   = (!empty ($_REQUEST['EMAIL'])   ? strip_white_space ($_REQUEST['EMAIL'])   : '');
   $data['SUBJECT'] = (!empty ($_REQUEST['SUBJECT']) ? strip_white_space ($_REQUEST['SUBJECT']) : '');
   $data['MESSAGE'] = (!empty ($_REQUEST['MESSAGE']) ? strip_white_space ($_REQUEST['MESSAGE']) : '');

   //Take care of white-space chars
   //$data = filter_white_space($data);

   if (VISUAL_CONFIRM == 1 && !empty ($_POST['CAPTCHA']))
   {
      $data = array_merge ($data, array ('CAPTCHA' => $_POST['CAPTCHA'], 'IMAGEHASH' => $_POST['IMAGEHASH']));
   }

   //RALUCA: JQuery validation related - server side.
   $validator = new Validator($validators);
   $validator_res = $validator->validate($_POST);
   //RALUCA: end of JQuery validation related - server side.
   if (VISUAL_CONFIRM == 2) {
//do the math
if (!isset($_SESSION['DO_MATH_N1']) || !isset($_SESSION['DO_MATH_N2'])) $validator_res['DO_MATH'] = 'Not a legitimate submit';
	if ($_REQUEST['DO_MATH'] != $_SESSION['DO_MATH_N1']+$_SESSION['DO_MATH_N2'])
		$validator_res['DO_MATH'] = 'Please Check Your Math Below';
// end do math
}
   if (empty($validator_res))
   {
      //Validate for banned words
      //Pass all submition data as parameter
      $fields = array ('NAME', 'SUBJECT', 'MESSAGE');
      $hasBannedWords = if_word_is_banned($data, $fields);
      if ($hasBannedWords == 1)
      {
         //Invalid submission,
         //Block access
         unset ($data);
         $reason = _L('The administrator of this link directory, has banned words from your submition.');
         gotoUnauthorized($reason);
      }

      //Initialize emailer
      require_once 'libs/phpmailer/class.phpmailer.php';
      require_once 'libs/phpmailer/class.phpmailercustom.php';

      $mail            = new PHPMailerCustom();
      $mail->PluginDir = 'libs/phpmailer/';

      //Load email method
      $mail->Mailer    = EMAIL_METHOD;
      switch (EMAIL_METHOD)
      {
         case 'smtp' :
            $mail->Host = EMAIL_SERVER;
            if (strlen (EMAIL_USER) > 0)
            {
               $mail->SMTPAuth = true;
               $mail->Username = EMAIL_USER;
               $mail->Password = EMAIL_PASS;
            }
            break;
         case 'sendmail' :
            $mail->Sendmail = EMAIL_SENDMAIL;
            break;
         default :
            break;
      }

      //Add sender
      $mail->From     = $data['EMAIL'];
      $mail->FromName = $data['NAME'];

      //Add receiver
      if (defined ('SITE_CONTACT_EMAIL') && strlen (SITE_CONTACT_EMAIL) > 0)
      {
         $mail->AddAddress(SITE_CONTACT_EMAIL);
      }
      else
      {
         $sql = "SELECT `NAME`, `EMAIL` FROM `{$tables['user']['name']}` WHERE `LEVEL` = '1' LIMIT 1";
         $admin = $db->GetRow($sql);
         $mail->AddAddress($admin['EMAIL'], $admin['NAME']);

         unset ($admin);
      }

      //Add subject
      $mail->Subject = $data['SUBJECT'];

      //Add body message
      $bodyMsg  = '';
      $bodyMsg .= "******************************\n";
      $bodyMsg .= _L('Subject').': '.$data['SUBJECT']."\n";
      $bodyMsg .= _L('Name')   .': '.$data['NAME']."\n";
      $bodyMsg .= _L('Email')  .': '.$data['EMAIL']."\n";
      $bodyMsg .= _L('Date')   .': '.gmdate ('Y-m-d H:i:s')."\n";
      $bodyMsg .= _L('IP')     .': '.(!empty ($client_info['IP']) ? $client_info['IP'] : _L('Unknown'))."\n";
      $bodyMsg .= "******************************\n\n";
      $bodyMsg .= trim ($data['MESSAGE']);

      $mail->Body = $bodyMsg;

      //Send email
      if (!$mail->Send())
      {
         $error++;
         $errorMsg = $mail->ErrorInfo;
         $tpl->assign('contactSent', 0);
      }
      else
      {
         unset ($data);
         $tpl->assign('contactSent', 1);
      }

      //Clear all addresses (and attachments) for next loop
      $mail->ClearAddresses();
      $mail->ClearAttachments();

      //Free memory
      unset ($mail, $bodyMsg, $_POST, $_REQUEST, $_GET);
   }
   else
      $tpl->assign($_POST);
   if (VISUAL_CONFIRM == 2) {
		//do the math get error
		  $tpl->assign('error_list', $validator_res);
		  // end do the math
		}
}

if (VISUAL_CONFIRM == 1)
   $tpl->assign('captcha_length', CAPTCHA_PHRASE_LENGTH);

$tpl->assign($data);
$tpl->assign('error'   , $error);
$tpl->assign('errorMsg', $errorMsg);

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');
if (VISUAL_CONFIRM == 2) {
// do the math
$n1 = $_SESSION['DO_MATH_N1'];
$n2 = $_SESSION['DO_MATH_N2'];

$tpl->assign('DO_MATH_N1', $n1);
$tpl->assign('DO_MATH_N2', $n2);
// end do math
	}
//Make output
echo $tpl->fetch('contact.tpl');
?>