{* Error and confirmation messages *}
{include file="messages.tpl"}

{strip}
{if (isset($error) and $error gt 0) or !empty($sql_error)}
   <div class="error block">
      <h2>{l}Error{/l}</h2>
      <p>{l}An error occured while saving.{/l}</p>
      {if !empty($errorMsg)}
         <p>{$errorMsg|escape}</p>
      {/if}
      {if !empty($sql_error)}
         <p>{l}The database server returned the following message:{/l}</p>
         <p>{$sql_error|escape}</p>
      {/if}
   </div>
{/if}

{if $posted}
   <div class="success block">
      {l}Widget settings saved.{/l}
   </div>
{/if}

<div class="block">
   <form method="post" action="">
   <table class="formPage">

   <thead>
      <tr>
         <th colspan="2">
               {l}Edit widget settings{/l}
         </th>
      </tr>
  </thead>

   <tbody>
      {section name=k loop=$list}
      <tr>
         <td class="label required"><label for="{$list[k].SETTING_NAME}">{l}{$list[k].SETTING_NAME}{/l}:</label></td>
         <td class="smallDesc">
            {if $list[k].SETTING_ALLOWED[0] neq ''}
            <select id="{$list[k].IDENTIFIER}" name="{$list[k].IDENTIFIER}">
            {section name=i loop=$list[k].SETTING_ALLOWED}
             <option value="{$list[k].SETTING_ALLOWED[i]}" {if $list[k].SETTING_VALUE eq $list[k].SETTING_ALLOWED[i]}selected="selected"{/if}>
             	{$list[k].SETTING_ALLOWED[i]}
             </option>
            {/section}
            </select>
           {else}
            <input type="text" id="{$list[k].IDENTIFIER}" name="{$list[k].IDENTIFIER}" value="{$list[k].SETTING_VALUE}" class="text" />
           {/if}
            <p class="limitDesc"><br/>{$list[k].SETTING_INFO}</p>
         </td>
      </tr>
      {/section}
   </tbody>

   <tfoot>
      <tr>
         <td><input type="reset" id="reset-widget-submit" name="reset" value="{l}Reset{/l}" alt="{l}Reset form{/l}" title="{l}Reset form{/l}" class="button" /></td>
         <td><input type="submit" id="send-widget-submit" name="save" value="{l}Save{/l}" alt="{l}Save form{/l}" title="{l}Save Widget Settings{/l}" class="button" /></td>
      </tr>
   </tfoot>
   </table>
   <input type="hidden" name="formSubmitted" value="1" />
   </form>
</div>
{/strip}