import React, { useEffect, useRef } from 'react';

export default function TextArea({
    type = 'text',
    name,
    value,
    className,
    autoComplete,
    required,
    isFocused,
    handleChange,
    placeholder,
}) {
    const input = useRef();

    useEffect(() => {
        if (isFocused) {
            input.current.focus();
        }
    }, []);

    return (
       
            <textarea
                type={type}
                name={name}
                value={value}
                className={
                    `form-control ` +
                    className
                }
                ref={input}
                autoComplete={autoComplete}
                required={required}
                placeholder={placeholder}
                onChange={(e) => handleChange(e)}
            >
            </textarea>
    );
}
